/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.data;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.GuiScreenConfig;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.client.CMessageOpenGui;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Vector3i;

public class ScreenConfigData
extends GuiData {
    public boolean onlyUpdate;
    public Vector3i pos;
    public BlockSide side;
    public NameUUIDPair[] friends;
    public int friendRights;
    public int otherRights;

    public ScreenConfigData() {
    }

    public ScreenConfigData(Vector3i pos, BlockSide side, TileEntityScreen.Screen scr) {
        this.pos = pos;
        this.side = side;
        this.friends = scr.friends.toArray(new NameUUIDPair[0]);
        this.friendRights = scr.friendRights;
        this.otherRights = scr.otherRights;
        this.onlyUpdate = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createGui(GuiScreen old, World world) {
        GuiScreenConfig gsc;
        if (old != null && old instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)old).isForBlock(this.pos.toBlock(), this.side)) {
            gsc.updateFriends(this.friends);
            gsc.updateFriendRights(this.friendRights);
            gsc.updateOtherRights(this.otherRights);
            gsc.updateMyRights();
            return null;
        }
        if (this.onlyUpdate) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntity at %s is not a screen; can't open gui!", this.pos.toString());
            return null;
        }
        return new GuiScreenConfig((TileEntityScreen)te, this.side, this.friends, this.friendRights, this.otherRights);
    }

    @Override
    public String getName() {
        return "ScreenConfig";
    }

    public ScreenConfigData updateOnly() {
        this.onlyUpdate = true;
        return this;
    }

    public void sendTo(NetworkRegistry.TargetPoint tp) {
        WebDisplays.NET_HANDLER.sendToAllAround((IMessage)new CMessageOpenGui(this), tp);
    }
}

